from tabular_data import Table
import datetime

class order:
    def __init__(self,cart,delivery_date):
        self._order_date=datetime.datetime.today()
        self._products=cart._products
        self._delivery_date=delivery_date
    def __str__(self):
        time_details='Order Date: '+self._order_date.strftime('%A %d %B %Y')
        t=Table(['Product Name', 'Product Price'],\
                    [p.name for p in self._products],\
                    [p.price for p in self._products])
        total=sum([p._price for p in self._products])
        duration = self._delivery_date-datetime.datetime.today()#Note we want today's date not order_date
        delivery_time=self._delivery_date.time().strftime('%I:%M %p')#format is 'hours:minutes am/pm'
        delivery_info='Your delivery is due in '+str(duration.days)+\
                       ' days and should be picked up (or delivered) at '+delivery_time
        return time_details+'\n'+str(t)+'\n'+'Total: '+str(total)+'\n'+delivery_info
        #each part of the string should be displayed on a new line

class CreditException(ValueError):
    pass

class payment:

    #Consturctor where user passing in all details at time of construction
    def __init__(self,customer_name,card_type,card_number,card_expiry,pin):
        self._payment_date=datetime.datetime.today()
        self._customer_name=self.validate(customer_name,'str',size=30)
        self._card_type=self.validate(card_type,'card',size=20)
        self._card_number=self.validate(card_number,'int',size=9)
        self._card_expiry=self.validate(card_expiry,'date',date_format='%m/%y')
        try:
            self._pin=self.validate(pin,'int',size=4)
        except ValueError:
            raise CreditException('The pin number should be 4 digits') from None

    #Interactive constructor that prompts for the details
    @classmethod
    def interative_payment(cls):
        return cls(cls.get_customer_name(),
                   cls.get_card_type(),
                   cls.get_card_number(),
                   cls.get_card_expiry(),
                   cls.get_pin())
        
    #methods for getting manual input
    @classmethod
    def get_customer_name(self):
        customer_name = input('Please enter the name on your credit card: ')
        return customer_name
    @classmethod
    def get_card_type(self):
        card_type = input ('Please enter the type of credit card: ')
        return card_type
    @classmethod
    def get_card_number(self):
        card_number = input ('Please enter the credit card number: ')
        return card_number
    @classmethod
    def get_card_expiry(self):
        card_expiry = input ('Please enter the expiry date of credit card (mm/yy): ')
        return card_expiry
    @classmethod
    def get_pin(self):
        pin = input ('Please enter the pin: ')
        return pin

    #Method to convert payment to string
    def __str__(self):
        return 'Name: '+str(self._customer_name)+'\n'\
               +'Type of card: '+str(self._card_type)+'\n'\
               +'Card number: '+str(self._card_number)+'\n'\
               +'Expiry: '+datetime.datetime.strftime(self._card_expiry,'%m/%y')+'\n'\
               +'Pin: '+str(self._pin)
        
    #validation methods
    def validate(self,input,datatype,**kwargs):
        #check length
        if kwargs.get('size'):#if size is one of the keyword args
            if len(str(input)) > int(kwargs.get('size')):
                raise CreditException('Input must not be more than '+str(kwargs.get('size'))+\
                      ' characters')
            if len(str(input)) ==0:
                raise CreditException('You must enter a value for this field')
        #check specifics for differnt types
        if datatype=='int':
            return int(input)
        if datatype=='date':
            try:
                return datetime.datetime.strptime(input,kwargs.get('date_format'))
            except ValueError as ve:
                raise CreditException(str(ve.args)) from None
        if datatype=='card':
            if input not in ['Visa','Master Card']:
                raise CreditException('Sorry we only accept Visa or Mastercard payments')
                
        #if we get this far then data is valid and a string
        #could use an assert statement here to check this.
        assert isinstance(input,str)
        return input 
            
        
        
